	function [Case, wcGT, wsGT, F1_EDGE, F2_EDGE] = FRM_CASE(wcT,wsT, M)
	
	% 	Determins the Case G or Gc for FRM filters with two masking filters.
	%	Determines also the band edges for the periodic filters G(z^M) and Gc(z^M).
	%	Determines also the band edges for the masking filters.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar, 2018-01-01
	% 	Modified by: 		 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	%  Determine the passband and stopband edge of the model filter
	k = floor(wcT*M/(2*pi));		k2pi = k*2*pi;
	wcGT = wcT*M-k2pi;				wsGT = wsT*M-k2pi;
	if (wcGT < wsGT) & (0 < wcGT) & (wsGT < pi)
		Case = 'G';
	else
		k = ceil(wsT*M/(2*pi));	k2pi = k*2*pi; Case = 'Gc';
		wcGT = k2pi-wsT*M; 			wsGT = k2pi-wcT*M;
	end
	% Determine the passband and stopband edges of the masking filters
	if (Case == 'G') % wcT_F0 = wcT and wsT_F1 = wsT
		wcT_F0 = (k2pi+wcGT)/M; 		wsT_F0 = (k2pi+2*pi-wsGT)/M;
		wcT_F1 = (k2pi-wcGT)/M;			wsT_F1 = (k2pi+wsGT)/M;
	else 	% Case == 'Gc'  wcT_F1 =  wcT and wsT_F0 = wsT
		wcT_F0 = (k2pi-2*pi+wsGT)/M;	wsT_F0 = (k2pi-wcGT)/M;
		wcT_F1 = (k2pi-wsGT)/M; 		wsT_F1 = (k2pi+wcGT)/M;		 
	end			 
	F1_EDGE = [0 wcT_F0 wsT_F0 pi];
	F2_EDGE = [0 wcT_F1 wsT_F1 pi];	
	
